package ru.yandex.reminders.api.callmeback;

import lombok.Data;
import lombok.val;

import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.security.AuthenticationType;
import ru.yandex.commune.a3.security.UnauthenticatedException;
import ru.yandex.commune.a3.security.UnauthorizedException;
import ru.yandex.inside.passport.tvm2.TvmHeaders;
import ru.yandex.passport.tvmauth.TicketStatus;
import ru.yandex.reminders.tvm.TvmClient;

@Data
public class TvmInvocationInterceptor implements ActionInvocationInterceptor {
    private final TvmClient client;
    private final long tvmId;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        val header = invocation.getWebRequest()
                .getHeader(TvmHeaders.SERVICE_TICKET)
                .getOrThrow(() -> new UnauthenticatedException(AuthenticationType.TVM, "Missing the required header: " + TvmHeaders.SERVICE_TICKET));

        val ticket = client.checkServiceTicket(header);

        if (ticket.getStatus() != TicketStatus.OK) {
            throw new UnauthorizedException("Something wrong with the received ticket. Status is: " + ticket.getStatus());
        }

        if (tvmId != ticket.getSrc().get()) {
            throw new UnauthorizedException("The source does not match the expected callmeback service!");
        }

        return invocation.invoke();
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.COMMON_ATTRIBUTES_INTERCEPTOR_ORDER;
    }
}