package ru.yandex.reminders.api.flight;

import lombok.val;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.DefaultActionConfiguration;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
public class ApiFlightContextConfiguration {

    @Bean
    public ActionApp mailActionApp(ApplicationContext context, ApplicationInfo info) {
        return ActionConfigurator.configure(
                Cf.list(flightRemindersActions()),
                DefaultActionConfiguration.defaultConfiguration(context, info));
    }

    @Bean
    public ActionInvocationServlet mailActionInvocationServlet(
            @Qualifier("apiJetty") SingleWarJetty jetty,
            @Qualifier("mailActionApp") ActionApp actionApp)
    {
        val servlet = actionApp.createServlet();
        jetty.addServletMapping("/mail/*", servlet);
        return servlet;
    }

    @Bean
    public FlightRemindersActions flightRemindersActions() {
        return new FlightRemindersActions();
    }

}
