package ru.yandex.reminders.api.flight;

import ru.yandex.bolts.collection.Option;
import ru.yandex.reminders.logic.flight.FlightCity;
import ru.yandex.reminders.logic.flight.FlightItem;

public class FlightPoint {
    private final FlightCity city;
    private final Option<FlightItem> airport;

    public FlightPoint(
            FlightCity city, Option<FlightItem> airport)
    {
        this.city = city;
        this.airport = airport;
    }

    public FlightCity getCity() {
        return city;
    }

    public Option<FlightItem> getAirport() {
        return airport;
    }

    public Option<String> getIataCode() {
        return airport.flatMapO(FlightItem::getIataCode);
    }

    public Option<String> getIcaoCode() {
        return airport.flatMapO(FlightItem::getIcaoCode);
    }

    public Option<Integer> getGeoId() {
        return city.getGeoId();
    }

    public String getCityName() {
        return city.getName();
    }

    public Option<String> getAirportName() {
        return airport.flatMapO(FlightItem::getName);
    }
}
