package ru.yandex.reminders.api.flight;

import org.joda.time.Duration;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;
import ru.yandex.reminders.log.TskvFields;
import ru.yandex.reminders.log.TskvLogDataSource;
import ru.yandex.reminders.logic.reminder.PhoneNumber;

@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class MailFlightRemindersData implements TskvLogDataSource {
    private PassportUid uid;
    private String ticketId;
    private String mid;
    private Option<String> lang;
    private Option<String> yaDomain;

    @BenderFlatten
    private MailReminderData reminderData;
    private ListF<MailFlightData> flights;

    public void validate() {
        Validate.notBlank(ticketId, "ticketId should not be blank");
        Validate.notNull(reminderData);
        Validate.notEmpty(flights, "Flights should be specified");
        reminderData.validate();
        flights.forEach(MailFlightData::validate);
    }

    public PassportUid getUid() {
        return uid;
    }

    public String getTicketId() {
        return ticketId;
    }

    public Option<PhoneNumber> getPhone() {
        return reminderData.getPhone();
    }

    public Option<Duration> getUserSmsOffset() {
        return reminderData.getUserSmsOffset();
    }

    public Option<Duration> getAutoEmailOffset() {
        return reminderData.getAutoEmailOffset();
    }

    public Option<Duration> getAutoSmsOffset() {
        return reminderData.getAutoSmsOffset();
    }

    public Option<Email> getEmail() {
        return reminderData.getEmail();
    }

    public String getMid() {
        return mid;
    }

    public Option<String> getLang() {
        return lang;
    }

    public Option<String> getYaDomain() {
        return yaDomain;
    }

    public MailReminderData getReminderData() {
        return reminderData;
    }

    public ListF<MailFlightData> getFlights() {
        return flights;
    }

    @Override
    public Tuple2List<String, String> tskvLogData() {
        return Tuple2List.fromPairs(TskvFields.UID, "" + uid, TskvFields.ID, ticketId, TskvFields.MID, mid);
    }
}
