package ru.yandex.reminders.api.flight;

import org.joda.time.Duration;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.api.a3.bind.JsonActionResult;
import ru.yandex.reminders.logic.flight.FlightRemindersInfo;
import ru.yandex.reminders.logic.reminder.PhoneNumber;

@JsonActionResult(resultFieldName = "remindersInfo")
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class MailFlightRemindersInfo {

    private final Option<Duration> userSmsOffset;
    private final Option<PhoneNumber> phone;
    private final Duration availableOffset;

    private final Option<Duration> autoSmsOffset;
    private final Option<Duration> autoEmailOffset;

    public MailFlightRemindersInfo(
            Option<Duration> userSmsOffset, Option<PhoneNumber> phone, Duration availableOffset,
            Option<Duration> autoSmsOffset, Option<Duration> autoEmailOffset) {
        this.userSmsOffset = userSmsOffset;
        this.phone = phone;
        this.availableOffset = availableOffset;
        this.autoSmsOffset = autoSmsOffset;
        this.autoEmailOffset = autoEmailOffset;
    }

    public static MailFlightRemindersInfo cons(FlightRemindersInfo info) {
        return new MailFlightRemindersInfo(
                info.getUserSmsOffset(), info.getPhone(),
                info.getAvailableOffset(), info.getAutoSmsOffset(), info.getAutoEmailOffset());
    }
}
