package ru.yandex.reminders.api.flight;

import org.joda.time.Duration;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;
import ru.yandex.reminders.logic.reminder.PhoneNumber;

@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class MailReminderData {
    private Option<PhoneNumber> phone;
    private Option<Duration> autoSmsOffset;
    private Option<Duration> userSmsOffset;

    private Option<Email> email;
    private Option<Duration> autoEmailOffset;

    public MailReminderData(Option<PhoneNumber> phone, Option<Duration> autoSmsOffset, Option<Duration> userSmsOffset,
                            Option<Email> email, Option<Duration> autoEmailOffset) {
        this.phone = phone;
        this.autoSmsOffset = autoSmsOffset;
        this.userSmsOffset = userSmsOffset;
        this.email = email;
        this.autoEmailOffset = autoEmailOffset;
    }

    public static MailReminderData empty() {
        return new MailReminderData(Option.none(), Option.none(), Option.none(), Option.none(), Option.none());
    }

    public void validate() {
        Validate.notEmpty(userSmsOffset.plus(autoSmsOffset).plus(autoEmailOffset),
                "At least one offset should be specified");
        Validate.isFalse(autoEmailOffset.isDefined() && email.isEmpty(), "Email address should be specified");
    }

    public Option<Duration> getUserSmsOffset() {
        return userSmsOffset;
    }

    public Option<Duration> getAutoSmsOffset() {
        return autoSmsOffset;
    }

    public Option<PhoneNumber> getPhone() {
        return phone;
    }

    public Option<Duration> getAutoEmailOffset() {
        return autoEmailOffset;
    }

    public Option<Email> getEmail() {
        return email;
    }
}
