package ru.yandex.reminders.api.reminder;

import lombok.val;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.DefaultActionConfiguration;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.error.A3ExceptionHandler;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;
import ru.yandex.reminders.api.a3.SafeMessageAnyExceptionHandler;
import ru.yandex.reminders.api.a3.bind.JsonBinderParseExceptionHandler;
import ru.yandex.reminders.api.unistat.UnistatConfiguration;

@Configuration
@Import({
        UnistatConfiguration.class,
})
public class ApiReminderContextConfiguration {
    @Bean
    public ActionApp reminderActionApp(ApplicationContext context, ApplicationInfo info) {
        val exceptionHandlers = Cf.list(
                new A3ExceptionHandler(),
                new JsonBinderParseExceptionHandler(),
                new SafeMessageAnyExceptionHandler());

        return ActionConfigurator.configure(
                Cf.list(reminderActions()),
                DefaultActionConfiguration.defaultConfiguration(context, info).setExceptionHandlers(exceptionHandlers));
    }

    @Bean
    public ActionInvocationServlet reminderActionInvocationServlet(
            @Qualifier("apiJetty") SingleWarJetty jetty,
            @Qualifier("reminderActionApp") ActionApp actionApp) {
        val servlet = actionApp.createServlet();
        jetty.addServletMapping("/api/*", servlet);
        return servlet;
    }

    @Bean
    public ReminderActions reminderActions() {
        return new ReminderActions();
    }

    @Bean
    public ConverterToIterationKey converterToIterationKey() {
        return new ConverterToIterationKey();
    }
}
