package ru.yandex.reminders.api.reminder;

import ru.yandex.commune.a3.action.parameter.ValidateParam;
import ru.yandex.misc.dataSize.DataSize;

public enum LenLimits {

    JSON_DATA(DataSize.fromKiloBytes(200)),
    EMAIL(DataSize.fromKiloBytes(200)),
    SMS(DataSize.fromBytes(140), error("140 unicode chars")) {
        @Override
        protected long length(String paramValue) {
            return paramValue.length();
        }
    },
    ;

    private final long limit;
    private final String error;

    LenLimits(DataSize limit) {
        this(limit, error(limit.toStringKiloBytes()));
    }

    LenLimits(DataSize limit, String error) {
        this.limit = limit.toBytes();
        this.error = error;
    }

    public void checkParam(String paramName, String paramValue) {
        if (length(paramValue) > limit) {
            ValidateParam.fail(paramName, String.format(error, paramName));
        }
    }

    protected long length(String paramValue) {
        return paramValue.getBytes().length;
    }

    static String error(String s) {
        return String.format(Template.ERROR_TEMPLATE, "%s", s);
    }

    interface Template {
        String ERROR_TEMPLATE = "Value of field '%s' is too long, limit is %s";
    }
}
