package ru.yandex.reminders.api.reminder;

import org.joda.time.DateTime;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.log.TskvFields;
import ru.yandex.reminders.log.TskvLogDataSource;
import ru.yandex.reminders.logic.event.EventDataUtils;

@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class ReminderData implements TskvLogDataSource {
    private final Option<String> name;
    private final Option<String> description;
    private final Option<ReminderDate> reminderDate;

    private final ChannelsData channels;
    private final Option<JsonValue> data;

    public ReminderData(
            Option<String> name, Option<String> description,
            Option<DateTime> reminderDate, ChannelsData channels, Option<JsonObject> data)
    {
        this.name = name;
        this.description = description;
        this.reminderDate = reminderDate.map(ReminderDate::new);
        this.channels = channels;
        this.data = data.uncheckedCast();
    }

    public Option<String> getName() {
        return name;
    }

    public Option<String> getDescription() {
        return description;
    }

    public Option<DateTime> getReminderDate() {
        return reminderDate.map(ReminderDate::getDate);
    }

    public ChannelsData getChannels() {
        return channels;
    }

    public Option<JsonValue> getData() {
        return data;
    }

    @Override
    public Tuple2List<String, String> tskvLogData() {
        return Tuple2List.tuple2List(EventDataUtils.extractMid(data).map(v -> Tuple2.tuple(TskvFields.MID, v)));
    }
}
