package ru.yandex.reminders.api.reminder;

import org.joda.time.DateTime;
import ru.yandex.commune.a3.action.parameter.IllegalParameterException;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.reminders.api.DateTimeConverters;

@Bendable
public class ReminderDate {

    private final DateTime date;

    public ReminderDate(DateTime date) {
        this.date = date;
    }

    @BenderTextValue
    public static ReminderDate parse(String value) {
        try {
            return new ReminderDate(DateTimeConverters.dateTimeWithTzConverter.parse(value));

        } catch (IllegalArgumentException e) {
            throw new IllegalParameterException("reminderDate", "Field 'reminderDate' value is malformed");
        }
    }

    @BenderTextValue
    public String serialize() {
        return DateTimeConverters.dateTimeWithTzConverter.toString(date);
    }

    public DateTime getDate() {
        return date;
    }
}
