package ru.yandex.reminders.api.reminder;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.api.a3.bind.JsonActionResult;
import ru.yandex.reminders.logic.event.IterationKey;

@JsonActionResult
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class RemindersInfo {
    private final ListF<ReminderInfo> reminders;
    private final Option<IterationKey> iterationKey;
    private final Option<Long> totalCount;

    public RemindersInfo(ListF<ReminderInfo> reminders, Option<IterationKey> iterationKey, Option<Long> totalCount) {
        this.reminders = reminders;
        this.iterationKey = iterationKey;
        this.totalCount = totalCount;
    }

    public ListF<String> getIds() {
        return reminders.map(ReminderInfo::getId);
    }

    public Option<IterationKey> getIterationKey() {
        return iterationKey;
    }

    public Option<Long> getTotalCount() {
        return totalCount;
    }
}
