package ru.yandex.reminders.api.reminder;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author Eugene Voytitsky
 */
public enum Source implements IntEnum {
    INTERNAL(0),
    EXTERNAL(1),
    ;

    public static IntEnumResolver<Source> R = IntEnumResolver.r(Source.class);

    private final int value;

    private Source(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }
}
