package ru.yandex.reminders.api.tv;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.DefaultActionConfiguration;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.error.A3ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.AnyExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.nested.ExceptionWithRootElementHandler;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
public class ApiTvContextConfiguration {
    @Bean
    public ActionApp tvActionApp(ApplicationContext context, ApplicationInfo info) {
        ListF<ExceptionHandler> exceptionHandlers = Cf.list(
                new ExceptionWithRootElementHandler(),
                new A3ExceptionHandler(),
                new AnyExceptionHandler());

        return ActionConfigurator.configure(
                Cf.<Object>list(tvRemindersActions()),
                DefaultActionConfiguration.defaultConfiguration(context, info).setExceptionHandlers(exceptionHandlers));
    }

    @Bean
    public ActionInvocationServlet tvActionInvocationServlet(
            @Qualifier("apiJetty") SingleWarJetty jetty,
            @Qualifier("tvActionApp") ActionApp actionApp)
    {
        ActionInvocationServlet servlet = actionApp.createServlet();
        jetty.addServletMapping("/tv/*", servlet);
        return servlet;
    }

    @Bean
    public TvRemindersActions tvRemindersActions() {
        return new TvRemindersActions();
    }

    @Bean
    public ConverterToTvProgramId converterToTvProgramId() {
        return new ConverterToTvProgramId();
    }

    @Bean
    public ConverterToTvChannelId converterToTvChannelId() {
        return new ConverterToTvChannelId();
    }
}
