package ru.yandex.reminders.api.tv;

import org.joda.time.DateTime;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.logic.tv.TvChannelProgramId;
import ru.yandex.reminders.logic.tv.TvReminder;

/**
 * @author dbrylev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class TvProgramEventData {
    private final DateTime startTime;
    private final int offsetMinutes;
    private final String text;

    private TvProgramEventData(DateTime startTime, int offsetMinutes, String text) {
        this.startTime = startTime;
        this.offsetMinutes = offsetMinutes;
        this.text = text;
    }

    public static Function<TvReminder, TvProgramEventData> fromReminderF() {
        return new Function<TvReminder, TvProgramEventData>() {
            public TvProgramEventData apply(TvReminder r) {
                return new TvProgramEventData(r.getEventDate(), r.getOffsetMinute(), r.getMessage());
            }
        };
    }

    public static Function<TvProgramEventData, TvReminder> toReminderF(final TvChannelProgramId programId) {
        return new Function<TvProgramEventData, TvReminder>() {
            public TvReminder apply(TvProgramEventData e) {
                return new TvReminder(
                        programId.getProgramId(), programId.getChannelId(),
                        e.startTime, e.offsetMinutes, e.text);
            }
        };
    }
}
