package ru.yandex.reminders.api.tv;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function2;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.logic.tv.TvChannelId;
import ru.yandex.reminders.logic.tv.TvChannelProgramId;
import ru.yandex.reminders.logic.tv.TvProgramId;
import ru.yandex.reminders.logic.tv.TvReminder;

/**
 * @author dbrylev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class TvProgramRemindersData {

    private final TvProgramId programId;
    private final TvChannelId channelId;

    private final ListF<TvProgramEventData> events;

    public TvProgramRemindersData(TvProgramId programId, TvChannelId channelId, ListF<TvProgramEventData> events) {
        this.programId = programId;
        this.channelId = channelId;
        this.events = events;
    }

    public TvChannelProgramId getProgramId() {
        return new TvChannelProgramId(programId, channelId);
    }

    public ListF<TvReminder> getReminders() {
        return events.map(TvProgramEventData.toReminderF(getProgramId()));
    }

    public static Function2<TvChannelProgramId, ListF<TvProgramEventData>, TvProgramRemindersData> consF() {
        return (id, events) -> new TvProgramRemindersData(id.getProgramId(), id.getChannelId(), events);
    }
}
