package ru.yandex.reminders.api.unistat;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.DefaultActionConfiguration;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import({
        UnistatConfiguration.class,
})
public class ApiUnistatContextConfiguration {
    @Bean
    public ActionApp unistatActionApp(ApplicationContext context, ApplicationInfo info) {
        return ActionConfigurator.configure(
                Cf.list(unistatActions()),
                DefaultActionConfiguration.defaultConfiguration(context, info).setResultType(MediaType.TEXT_PLAIN));
    }

    @Bean
    public ActionInvocationServlet unistatActionInvocationServlet(
            @Qualifier("apiJetty") SingleWarJetty jetty,
            @Qualifier("unistatActionApp") ActionApp actionApp) {
        ActionInvocationServlet servlet = actionApp.createServlet();
        jetty.addServletMapping("/unistat", servlet);
        return servlet;
    }

    @Bean
    public UnistatActions unistatActions() {
        return new UnistatActions();
    }
}
