package ru.yandex.reminders.boot;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.commune.dynproperties.DynamicPropertiesContextConfiguration;
import ru.yandex.misc.version.Version;
import ru.yandex.reminders.admin.RemindersAdminContextConfiguration;
import ru.yandex.reminders.logic.event.EventContextConfiguration;
import ru.yandex.reminders.logic.reminder.ReminderContextConfiguration;
import ru.yandex.reminders.logic.user.UserContextConfiguration;

@Configuration
@Import({
    InitContextConfiguration.class,
    RemindersAdminContextConfiguration.class,
    ReminderContextConfiguration.class,
    EventContextConfiguration.class,
    UserContextConfiguration.class,
    DynamicPropertiesContextConfiguration.class,
})
public class RemindersAppContextConfiguration {

    @Bean
    public Version version() {
        return RemindersAppVersion.VERSION;
    }

}
