package ru.yandex.reminders.boot;

import ru.yandex.misc.enums.EnumResolver;
import ru.yandex.misc.version.AppName;

public enum RemindersAppName implements AppName {
    API,
    WORKER,
    ;

    public static EnumResolver<RemindersAppName> R = EnumResolver.er(RemindersAppName.class);

    @Override
    public String serviceName() {
        return "reminders";
    }

    @Override
    public String appName() {
        return R.toXmlName(this);
    }
}
