package ru.yandex.reminders.boot;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.commune.lockservice.LockServiceConfiguration;
import ru.yandex.commune.lockservice.client.LocalLockClient;
import ru.yandex.commune.lockservice.client.LockClient;
import ru.yandex.commune.lockservice.client.LockClientContextConfiguration;
import ru.yandex.commune.lockservice.client.RemoteLockClient;
import ru.yandex.commune.lockservice.service.LockServiceContextConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;
import ru.yandex.misc.env.Environment;
import ru.yandex.misc.env.EnvironmentType;

@Configuration
@Import({
    LockServiceContextConfiguration.class,
    LockClientContextConfiguration.class,
    RemindersZkContextConfiguration.class,
    ZkManagerContextConfiguration.class
})
public class RemindersLockServiceContextConfiguration {

    @Bean
    public LockServiceConfiguration lockServiceConfiguration(
            @Qualifier("zkRoot") ZkPath zkRoot,
            @Value("${lockservice.port}") int port)
    {
        return new LockServiceConfiguration(port, zkRoot.child("lock"));
    }

    @Bean
    public LockClient lockClient(RemoteLockClient remoteLockClient, EnvironmentType environmentType) {
        return environmentType != EnvironmentType.TESTS && !Environment.isDeveloperNotebook()
                ? remoteLockClient
                : new LocalLockClient();
    }
}
