package ru.yandex.reminders.boot;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.commune.mongo3.schema.MongoSchemaCheckerContextConfiguration;
import ru.yandex.commune.mongo3.schema.SchemaCheckAtStartupPolicy;
import ru.yandex.reminders.mongodb.MongoDaoContextConfiguration;
import ru.yandex.reminders.mongodb.MongoDbContextConfiguration;

@Configuration
@Import({
        MongoDbContextConfiguration.class,
        MongoDaoContextConfiguration.class,
        MongoSchemaCheckerContextConfiguration.class
})
public class RemindersMongoContextConfiguration {

    @Bean
    public SchemaCheckAtStartupPolicy mongoSchemaCheckAtStartupPolicy() {
        return SchemaCheckAtStartupPolicy.TRY_UPDATE;
    }
}
