package ru.yandex.reminders.boot;

import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.property.load.strategy.PropertiesBuilder;
import ru.yandex.misc.property.load.strategy.PropertiesLoadStrategy;

public class RemindersPropertiesLoadStrategy implements PropertiesLoadStrategy {

    private final RemindersAppName appName;
    private final boolean forTests;

    public RemindersPropertiesLoadStrategy(RemindersAppName appName, boolean forTests) {
        this.appName = appName;
        this.forTests = forTests;
    }

    @Override
    public void load(PropertiesBuilder t, EnvironmentType envType) {
        t.set("app.name", appName.appName());
        t.setDefault(EnvironmentType.YANDEX_ENVIRONMENT_TYPE_PROPERTY, envType.getValue());

        t.includeSystemProperties();

        t.include("classpath:ru/yandex/reminders/application-default.properties");
        t.include("classpath:ru/yandex/reminders/application-" + envType.name().toLowerCase() + ".properties");

        if (forTests) {
            t.includeIfExists("classpath:ru/yandex/reminders/application-tests.properties");
        }

        t.includeIfExists("/etc/reminders/" + appName.appName() + "/application.properties");
        t.includeIfExists("/etc/reminders/secrets.properties");

        t.includeCmdLineProperties();

        t.copyCutPrefix(appName.appName() + ".");
        t.copyCutPrefix(envType.getValue() + ".");
    }
}
