package ru.yandex.reminders.boot;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.zk2.ZkConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorContextConfiguration;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.net.HostnameUtils;

@Configuration
@Import({
    ConductorContextConfiguration.class,
    ZkManagerContextConfiguration.class
})
public class RemindersZkContextConfiguration {

    @Autowired
    private EnvironmentType environmentType;
    @Autowired
    private Conductor conductor;

    @Qualifier("zkRoot")
    @Bean
    public ZkPath zkRoot() {
        String environmentId = environmentType == EnvironmentType.DEVELOPMENT
                ? HostnameUtils.localHostname()
                : environmentType.getValue();

        return new ZkPath("/reminders/" + environmentId);
    }

    @Bean
    public ZkConfiguration zkConfiguration(
            @Value("${zookeeper.hosts:-}") String zkHosts,
            @Value("${zookeeper.conductor.group:-}") String zkConductorGroup,
            @Value("${zookeeper.port}") int zkPort)
    {
        if (StringUtils.isNotEmpty(zkConductorGroup)) {
            return new ZkConfiguration(conductor.getGroupHosts(zkConductorGroup), zkPort);
        }
        return new ZkConfiguration(Cf.x(zkHosts.split(",")).filter(StringUtils.notEmptyF()), zkPort);
    }

}
