package ru.yandex.reminders.i18n;

public abstract class BaseLocalizedString implements LocalizedString {

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof LocalizedString)) {
            return false;
        }

        LocalizedString that = (LocalizedString) other;
        for (Language lang : Language.R.valuesList()) {
            if (!that.get(lang).equals(this.get(lang))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final int hashCode() {
        return Language.R.valuesList().map(this::get).sorted().hashCode();
    }

    @Override
    public String toString() {
        return getClass() + asMap().toString();
    }

}
