package ru.yandex.reminders.i18n;

import ru.yandex.bolts.collection.MapF;

public final class ConstLocalizedString extends BaseLocalizedString {

    private final String value;

    private ConstLocalizedString(String value) {
        this.value = value;
    }

    @Override
    public String get(Language language) {
        return value;
    }

    @Override
    public MapF<String, String> asMap() {
        return Language.R.valuesList().map(Enum::name).zipWith(language -> value).toMap();
    }

    @Override
    public String toString() {
        return value;
    }

    public static ConstLocalizedString cons(String value) {
        return new ConstLocalizedString(value);
    }

    public static LocalizedString empty() {
        return ConstLocalizedString.cons("");
    }
}
