package ru.yandex.reminders.i18n;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

import java.util.Locale;

public enum Language implements StringEnum {
    RUSSIAN("ru"),
    TURKISH("tr"),
    ;

    private final String code;

    Language(String code) {
        this.code = code;
    }

    @Override
    public String value() {
        return code;
    }

    public Locale toLocale() {
        return Locale.forLanguageTag(code);
    }

    public static Language fromCodeOrRussian(Option<String> code) {
        return code.flatMapO(R::fromValueO).getOrElse(Language.RUSSIAN);
    }

    public static final StringEnumResolver<Language> R = StringEnumResolver.r(Language.class);
}
