package ru.yandex.reminders.i18n;

public final class LocalizedFormatter {

    public static String format(Language language, LocalizedString string, Object... args) {
        String format = string.get(language);
        StringBuilder result = new StringBuilder();

        int start = 0;
        for (int i = format.indexOf('{', start); i != -1; i = format.indexOf('{', start)) {
            result.append(format.substring(start, i).replace("}}", "}"));
            if (i == format.length() - 1) {
                result.append('{');
            } else if (format.charAt(i + 1) == '{') {
                result.append('{');
                i++;
            } else {
                int end = format.indexOf('}', i);
                result.append(get(language, format.substring(i + 1, end), args));
                i = end;
            }
            start = i + 1;
        }

        if (start < format.length()) {
            result.append(format, start, format.length());
        }

        return result.toString();
    }

    private static Object get(Language language, String group, Object... args) {
        int colon = group.indexOf(':');
        if (colon == -1) {
            return getValue(Integer.parseInt(group), language, args);
        }

        int index = Integer.parseInt(group.substring(0, colon));
        String format = "%" + group.substring(colon + 1);
        return String.format(format, getValue(index, language, args));
    }

    private static Object getValue(int index, Language language, Object... args) {
        Object result = args[index];
        if (result instanceof LocalizedString) {
            return LocalizedString.class.cast(result).get(language);
        }
        return result;
    }

    private LocalizedFormatter() { }
}
