package ru.yandex.reminders.i18n;

import ru.yandex.bolts.collection.MapF;

public interface LocalizedString {

    String get(Language language);

    default MapF<String, String> asMap() {
        return Language.R.valuesList().toMap(Language::name, this::get);
    }

    default LocalizedString format(Object... args) {
        return new FormattingLocalizedString(this, args);
    }
}
