package ru.yandex.reminders.i18n;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;

public class LocalizedStringBuilder {

    private final ListF<LocalizedString> parts;

    public static LocalizedStringBuilder empty() {
        return new LocalizedStringBuilder();
    }

    public LocalizedStringBuilder() {
        this.parts = Cf.arrayList();
    }

    public LocalizedStringBuilder append(LocalizedString part) {
        parts.add(part);
        return this;
    }

    public LocalizedStringBuilder append(String part) {
        return append(ConstLocalizedString.cons(part));
    }

    public LocalizedStringBuilder append(char character) {
        return append(String.valueOf(character));
    }

    public LocalizedStringBuilder nl() {
        return append("\n");
    }

    public LocalizedString build() {
        return new BaseLocalizedString() {
            @Override
            public String get(Language language) {
                return parts.map(part -> part.get(language)).mkString("");
            }
        };
    }
}
