package ru.yandex.reminders.i18n;

import lombok.val;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.CharsetUtils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Messages {

    public static final Messages M = new Messages();

    private final MapF<Language, MapF<String, String>> source;

    public Messages() {
        MapF<Language, MapF<String, String>> map = Cf.hashMap();
        for (String base : Cf.list(
                "ru/yandex/reminders/i18n/flights"))
        {
            for (Language language : Language.R.valuesList()) {
                ResourceBundle bundle = ResourceBundle.getBundle(base, language.toLocale(), new Utf8Control());
                Enumeration<String> en = bundle.getKeys();
                while (en.hasMoreElements()) {
                    String key = en.nextElement();
                    String value = bundle.getString(key);
                    MapF<String, String> keys = map.getOrElse(language, Cf.<String, String>hashMap());
                    keys.put(key, value);
                    map.put(language, keys);
                }
            }
        }
        this.source = map.unmodifiable();
    }

    public String getMessage(String key, Language language) {
        Option<String> result = source.getTs(language).getO(key);
        if (result.isEmpty()) {
            result = source.getTs(Language.RUSSIAN).getO(key);
        }
        return result.getOrElse("Undefined message");
    }

    public MapF<String, String> getMessages(Language language) {
        return source.getOrThrow(language);
    }

    private static class Utf8Control extends ResourceBundle.Control {
        public ResourceBundle newBundle(
                String baseName, Locale locale, String format, ClassLoader loader, boolean reload)
                throws IOException
        {
            // The below is a copy of the default implementation.
            val bundleName = toBundleName(baseName, locale);
            val resourceName = toResourceName(bundleName, "properties");
            ResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URL url = loader.getResource(resourceName);
                if (url != null) {
                    URLConnection connection = url.openConnection();
                    if (connection != null) {
                        connection.setUseCaches(false);
                        stream = connection.getInputStream();
                    }
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, CharsetUtils.UTF8_CHARSET));
                } finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}
