package ru.yandex.reminders.i18n;

public class StaticInflectingLocalizedString implements InflectingLocalizedString {

    private final String key;

    public StaticInflectingLocalizedString(String key) {
        this.key = key;
    }

    @Override
    public String get(long quantity, Language language) {
        String suffix;
        long modHundred = quantity % 100;
        long modTen = modHundred % 10;
        if (modHundred >= 11 && modHundred <= 19) {
            suffix = Messages.M.getMessage(key + ".5", language);
        } else if (modTen == 1L) {
            suffix = Messages.M.getMessage(key + ".1", language);
        } else if (modTen == 2L || modTen == 3L || modTen == 4L) {
            suffix = Messages.M.getMessage(key + ".2", language);
        } else {
            suffix = Messages.M.getMessage(key + ".5", language);
        }
        return quantity + " " + suffix;
    }

    public String getKey() {
        return key;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || getClass() != other.getClass()) {
            return false;
        }

        StaticInflectingLocalizedString that = (StaticInflectingLocalizedString) other;
        return key.equals(that.key);
    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }
}
