package ru.yandex.reminders.log;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.parameter.Parameter;
import ru.yandex.commune.a3.action.parameter.SimpleBindingParameters;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.utils.Ordered;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.bender.BenderUtils;
import ru.yandex.misc.reflection.TypeX;
import ru.yandex.reminders.api.ApiBender;

public class TskvLogActionInvocationInterceptor implements ActionInvocationInterceptor {

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        Tuple2List<String, String> pairs = Tuple2List.arrayList();

        pairs.add(TskvFields.ACTION, invocation.getActionDescriptor().getPrettyName().replace("Temporary", ""));
        pairs.add(TskvFields.METHOD, invocation.getWebRequest().getHttpServletRequest().getMethod());
        pairs.add(TskvFields.URI, invocation.getWebRequest().getHttpServletRequest().getRequestURI());

        if (invocation.getActionDescriptor().getContainerObject() instanceof TskvLogDataSource) {
            pairs.addAll(((TskvLogDataSource) invocation.getActionDescriptor().getContainerObject()).tskvLogData());
        }

        for (Parameter param : invocation.getParameters()) {
            if (param.getValue().isEmpty()) continue;

            Option<SimpleBindingParameters> simpleBinding = param.getDescriptor().getSimpleBindingParameters();
            TypeX parameterType = param.getDescriptor().getParameterType().getActualType();

            Object value = param.getValue().get();

            if (parameterType.erasure().isAssignableTo(TskvLogDataSource.class)) {
                pairs.addAll(((TskvLogDataSource) value).tskvLogData());

            } else if (simpleBinding.isPresent()) {
                String name = param.getDescriptor()
                        .getAnnotationO(TskvName.class).map(TskvName::value)
                        .getOrElse(simpleBinding.get().getName());

                if (value instanceof Option) {
                    if (((Option) value).isPresent()) {
                        pairs.add(name, "" + ((Option) value).get());
                    }
                } else {
                    pairs.add(name, "" + value);
                }
            }
            if (simpleBinding.isEmpty() && BenderUtils.hasBendable(parameterType.erasure())) {
                pairs.add(TskvFields.BODY, new String(ApiBender.mapper.serializeJson(value)));
            }
        }

        Option<String> error = Option.empty();
        try {
            Object result = invocation.invoke();

            if (result instanceof ErrorResult) {
                error = Option.of(((ErrorResult) result).getMessage());
            }
            return result;

        } catch (Throwable t) {
            error = Option.of(ExceptionUtils.getAllMessages(t));
            throw t;

        } finally {
            error.forEach(e -> pairs.add(TskvFields.ERROR, e));
            TskvLogger.log(pairs);
        }
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
