package ru.yandex.reminders.log;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class TskvLogger {

    private static final Logger logger = LoggerFactory.getLogger("tskv");

    public static void log(Tuple2List<String, String> keyValues) {
        logger.info(keyValues.foldLeft("",
                (res, kv) -> res + (res.isEmpty() ? "" : "\t") + kv.get1() + "=" + kv.get2().replace('\t', ' ')));
    }
}
