package ru.yandex.reminders.log;

import lombok.val;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.reminders.logic.callmeback.in.CallbackRequest;
import ru.yandex.reminders.logic.event.Event;
import ru.yandex.reminders.logic.reminder.Channel;
import ru.yandex.reminders.logic.reminder.Reminder;
import ru.yandex.reminders.logic.reminder.SendStatus;

public class TskvReminderSendLogger {

    public static void log(Event event, Reminder reminder, SendStatus status) {
        log(CallbackRequest.create(event, reminder), status);
    }

    public static void log(CallbackRequest request, SendStatus status) {
        val reminder = request.getReminder();
        if (Cf.list(Channel.PANEL, Channel.CLOUD_API).containsTs(reminder.getChannel())) {
            return;
        }
        if (!status.isSent() && !status.isFailed()) {
            return;
        }
        Tuple2List<String, String> pairs = Tuple2List.arrayList();

        pairs.add(TskvFields.ACTION, "remind");
        pairs.add(TskvFields.CHANNEL, reminder.getChannel().toString().toLowerCase());
        pairs.add(TskvFields.REMINDER_DATE, reminder.getSendDate().toString());

        pairs.add(TskvFields.UID, request.getUid().toString());
        pairs.add(TskvFields.CID, request.getCid());
        Event.extractMid(request.getMeta(), request.getData()).ifPresent(mid -> pairs.add(TskvFields.MID, mid));

        pairs.add(TskvFields.ID, request.getId().getExtId());
        pairs.addAll(status.tskvLogData());

        TskvLogger.log(pairs);
    }
}
