package ru.yandex.reminders.logic.callback;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.inside.passport.tvm2.AddServiceTicketInterceptor;
import ru.yandex.misc.io.http.Timeout;

import java.util.Optional;

@Configuration
public class CallbackManagerContextConfiguration {

    @Bean
    public CallbackManager callbackManager(
            @Value("${callback.send.timeout.secs}") int timeoutSeconds,
            @Value("${callback.send.maxConnections}") int maxConnections,
            Optional<AddServiceTicketInterceptor> serviceTicketInterceptor) {
        return new CallbackManager(
                maxConnections, Timeout.seconds(timeoutSeconds),
                Cf.list(serviceTicketInterceptor.orElse(null)));
    }

}
