package ru.yandex.reminders.logic.callmeback;

import java.util.Arrays;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.misc.io.http.Timeout;
import ru.yandex.reminders.api.unistat.UnistatConfiguration;
import ru.yandex.reminders.tvm.TvmClient;

@Import(
        UnistatConfiguration.class
)
@Configuration
public class CallmebackManagerContextConfiguration {
    @Bean
    public CallmebackManager callmebackManager(
            @Value("${callmeback.send.timeout.secs}") int timeoutSeconds,
            @Value("${callmeback.send.maxConnections}") int maxConnections,
            TvmClient tvmClient, @Value("${callmeback.api.host}") String callmebackUrl,
            @Value("${reminders.api.host}") String remindersUrl,
            @Value("${callmeback.client.tvm.id}") int callmebackId,
            MeterRegistry meterRegistry)
    {
        return new CallmebackManager(
                maxConnections, Timeout.seconds(timeoutSeconds),
                Arrays.asList(new JsonContentTypeInterceptor(),
                        new CallmebackTicketInterceptor(tvmClient, callmebackId)),
                callmebackUrl, remindersUrl, meterRegistry);
    }
}