package ru.yandex.reminders.logic.callmeback;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

@AllArgsConstructor
public class HttpResponseRegistryInterceptor implements HttpResponseInterceptor {
    private final String metricName;
    private final MeterRegistry meterRegistry;

    @Override
    public void process(HttpResponse response, HttpContext context) {
        val status = response.getStatusLine().getStatusCode();
        val name = String.format("%s.%d", metricName, status);
        meterRegistry.counter(name).increment();
    }
}
