package ru.yandex.reminders.logic.callmeback;

import lombok.val;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;

import ru.yandex.commune.a3.action.result.type.MediaType;

public class JsonContentTypeInterceptor implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) {
        val finalRequest = request;

        while (request instanceof HttpRequestWrapper) {
            request = ((HttpRequestWrapper) request).getOriginal();
        }

        if (request.getHeaders(HttpHeaders.CONTENT_TYPE).length == 0) {
            finalRequest.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON.toString());
        }
    }
}
