package ru.yandex.reminders.logic.callmeback.in;

import java.util.Optional;

import lombok.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.reminders.logic.event.Event;
import ru.yandex.reminders.logic.event.EventData;
import ru.yandex.reminders.logic.event.EventId;
import ru.yandex.reminders.logic.flight.FlightEventMeta;
import ru.yandex.reminders.logic.reminder.Reminder;

@Value
@BenderBindAllFields
public class CallbackRequest {
    EventId id;
    Reminder reminder;
    EventData data;
    Optional<String> senderName;

    public PassportUid getUid() {
        return id.getUid();
    }

    public String getCid() {
        return id.getCid();
    }

    public String getExtId() {
        return id.getExtId();
    }

    public Optional<FlightEventMeta> getMeta() {
        return data.getFlightMeta().toOptional();
    }

    public static CallbackRequest create(Event event, Reminder reminder) {
        return new CallbackRequest(event.getId(), reminder, event.getEventData().withReminders(Cf.list()), event.getSenderName().toOptional());
    }
}