package ru.yandex.reminders.logic.cloudApi;

import org.joda.time.DateTime;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.serialize.simpleType.StringValueMarshaller;
import ru.yandex.reminders.api.DateTimeConverters;

public class CloudApiBender {
    public static final BenderMapper mapper = new BenderMapper(getConfiguration());

    public static BenderConfiguration getConfiguration() {
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(DateTime.class, new DateTimeMarshaller())
                        .build());
    }

    private static class DateTimeMarshaller extends StringValueMarshaller {
        protected String toStringValue(Object o) {
            return DateTimeConverters.dateTimeWithTzConverter.toString((DateTime) o);
        }
    }
}
