package ru.yandex.reminders.logic.cloudApi;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.misc.io.http.Timeout;

@Configuration
public class CloudApiContextConfiguration {

    @Bean
    public CloudApiClient cloudApiClient(
            @Value("${cloud.api.host}") String host,
            @Value("${cloud.api.timeout.secs}") int timeout,
            @Value("${cloud.api.maxConnections}") int maxConnections)
    {
        return new CloudApiClient(host, Timeout.seconds(timeout), maxConnections);
    }
}
