package ru.yandex.reminders.logic.cloudApi;

import org.joda.time.DateTime;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.reminders.logic.flight.FlightEventMeta;
import ru.yandex.reminders.logic.flight.FlightItem;

@BenderBindAllFields
public class Flight {

    @BenderPart(strictName = true)
    private final Option<String> flight_number;
    @BenderPart(strictName = true)
    private final Option<Airline> airline;
    @BenderPart(strictName = true)
    private final Option<Place> departure;
    @BenderPart(strictName = true)
    private final Option<Place> arrival;
    @BenderPart(strictName = true)
    private final Option<String> checkin_url;
    @BenderPart(strictName = true)
    private final String data_source = "mail";

    public Flight(FlightEventMeta flight) {
        this.flight_number = Option.some(flight.getFlightNumber());

        this.airline = flight.getAirline().map(Airline::new);

        this.departure = Option.of(new Place(
                flight.getDepartureAirport().map(Airport::new),
                flight.getDepartureCity().getName(),
                flight.getDepartureCity().getGeoId(),
                Option.of(flight.getDepartureDateTime())));

        this.arrival = Option.of(new Place(
                flight.getArrivalAirport().map(Airport::new),
                flight.getArrivalCity().getName(),
                flight.getArrivalCity().getGeoId(),
                flight.getArrivalDateTime()));

        this.checkin_url = flight.getCheckInLink();
    }

    @BenderBindAllFields
    public static class Place {
        @BenderPart(strictName = true)
        private final Option<Airport> airport;
        @BenderPart(strictName = true)
        private final String city_name;
        @BenderPart(strictName = true)
        private final Option<Integer> geo_id;
        @BenderPart(strictName = true)
        private final Option<DateTime> time;

        public Place(Option<Airport> airport, String cityName, Option<Integer> geoId, Option<DateTime> time) {
            this.airport = airport;
            this.city_name = cityName;
            this.geo_id = geoId;
            this.time = time;
        }
    }

    @BenderBindAllFields
    public static class Airport {
        @BenderPart(strictName = true)
        private final Option<String> name;
        @BenderPart(strictName = true)
        private final Option<String> iata_code;
        @BenderPart(strictName = true)
        private final Option<String> icao_code;
        @BenderPart(strictName = true)
        private final Option<String> sirena_code;
        @BenderPart(strictName = true)
        private final Option<String> ya_schedule_id;

        public Airport(FlightItem a) {
            this.name = a.getName();
            this.iata_code = a.getIataCode();
            this.icao_code = a.getIcaoCode();
            this.sirena_code = a.getSirenaCode();
            this.ya_schedule_id = a.getRaspId().map(s -> "" + s);
        }
    }

    @BenderBindAllFields
    public static class Airline {
        @BenderPart(strictName = true)
        private final Option<String> name;
        @BenderPart(strictName = true)
        private final Option<String> iata_code;
        @BenderPart(strictName = true)
        private final Option<String> icao_code;
        @BenderPart(strictName = true)
        private final Option<String> sirena_code;
        @BenderPart(strictName = true)
        private final Option<String> ya_schedule_id;

        public Airline(FlightItem a) {
            this.name = a.getName();
            this.iata_code = a.getIataCode();
            this.icao_code = a.getIcaoCode();
            this.sirena_code = a.getSirenaCode();
            this.ya_schedule_id = a.getRaspId().map(s -> "" + s);
        }
    }
}
