package ru.yandex.reminders.logic.event;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.reminders.api.unistat.UnistatConfiguration;
import ru.yandex.reminders.boot.RemindersMongoContextConfiguration;
import ru.yandex.reminders.mongodb.BazingaMongoClientContextConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import({
    RemindersMongoContextConfiguration.class,
    BazingaMongoClientContextConfiguration.class,
    UnistatConfiguration.class
})
public class EventContextConfiguration {
    @Bean
    public EventManager eventManager() {
        return new EventManager();
    }
}
