package ru.yandex.reminders.logic.event;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.api.reminder.Source;
import ru.yandex.reminders.logic.flight.FlightEventMeta;
import ru.yandex.reminders.logic.reminder.Reminder;
import ru.yandex.reminders.mongodb.CompressibleJsonObject;
import ru.yandex.reminders.mongodb.CompressibleString;

@Bendable
@BenderMembersToBind(value = MembersToBind.ALL_FIELDS)
public class EventData {
    private final Option<Source> source; // TODO: Option may be removed, if you migrate existent docs without this field
    private final Option<String> name;
    private final Option<CompressibleString> desc;
    private final Option<CompressibleJsonObject> data;

    private final ListF<Reminder> reminders;
    private final Option<FlightEventMeta> flight;

    public EventData(
            Option<Source> source, Option<String> name, Option<String> description,
            Option<JsonObject> data, ListF<Reminder> reminders)
    {
        this(source, name, description, data, reminders, Option.empty());
    }

    public EventData(
            Option<Source> source, Option<String> name, Option<String> description,
            Option<JsonObject> data, ListF<Reminder> reminders, Option<FlightEventMeta> flightEventMeta)
    {
        this.source = source;
        this.name = name;
        this.desc = description.map(CompressibleString.consF());
        this.data = data.map(CompressibleJsonObject.consF());
        this.reminders = reminders;
        this.flight = flightEventMeta;
    }

    public static EventData empty() {
        return new EventData(Option.empty(), Option.empty(), Option.empty(), Option.empty(), Cf.list());
    }

    public EventData withReminders(CollectionF<Reminder> reminders) {
        return new EventData(getSource(), getName(), getDescription(), getData(), reminders.toList(), getFlightMeta());
    }

    public EventData withFlightMeta(FlightEventMeta flightMeta) {
        return new EventData(getSource(), getName(), getDescription(), getData(), getReminders(), Option.some(flightMeta));
    }

    public Option<Source> getSource() {
        return source;
    }

    public Option<String> getName() {
        return name;
    }

    public Option<String> getDescription() {
        return desc.map(CompressibleString.getStringF());
    }

    public Option<JsonObject> getData() {
        return data.map(CompressibleJsonObject.getObjectF());
    }

    public Option<FlightEventMeta> getFlightMeta() {
        return flight;
    }

    public ListF<Reminder> getReminders() {
        return reminders;
    }
}
