package ru.yandex.reminders.logic.event;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;

public class EventDataUtils {

    public static Option<String> extractMid(Option<JsonValue> data) {
        Function<JsonObject, Option<String>> extractMid =
                d -> d.getO("mid").filterByType(JsonString.class).map(JsonString::getString);

        return data.filterByType(JsonObject.class).flatMapO(
                d -> extractMid.apply(d).orElse(
                        () -> d.getO("data").filterByType(JsonObject.class).flatMapO(extractMid)));
    }
}
