package ru.yandex.reminders.logic.event;

import org.bson.types.ObjectId;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.lang.DefaultObject;

@Bendable
@BenderMembersToBind(value = MembersToBind.ALL_FIELDS)
public class EventId extends DefaultObject {
    public static final long IDX_ZERO = 0;

    private final PassportUid uid;
    private final String cid;
    private final String extId;
    private final long idx; // artificial field, used as part of unique index when uid+cid+extId isn't unique

    public EventId(PassportUid uid, String cid) {
        this(uid, cid, generateExtId(), IDX_ZERO);
    }

    public EventId(PassportUid uid, String cid, Option<String> extId) {
        this(uid, cid, extId.getOrElse(generateExtIdF()), IDX_ZERO);
    }

    public EventId(PassportUid uid, String cid, String extId) {
        this(uid, cid, extId, IDX_ZERO);
    }

    public EventId(PassportUid uid, String cid, String extId, long idx) {
        this.uid = uid;
        this.cid = cid;
        this.extId = extId;
        this.idx = idx;
    }

    public static String generateExtId() {
        return ObjectId.get().toString();
    }

    public static Function0<String> generateExtIdF() {
        return EventId::generateExtId;
    }

    public PassportUid getUid() {
        return uid;
    }

    public String getCid() {
        return cid;
    }

    public String getExtId() {
        return extId;
    }

    public long getIdx() {
        return idx;
    }

}
