package ru.yandex.reminders.logic.event;

import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.reminders.logic.flight.FlightCity;
import ru.yandex.reminders.logic.flight.FlightEventMeta;
import ru.yandex.reminders.logic.flight.FlightItem;
import ru.yandex.reminders.logic.flight.FlightSource;

public class EventManagerTestCommon {
    static final String FLIGHT_NUM = "SU103";
    static final int GEO_ID = 43651;
    static final Instant PLANNED_TS = Instant.now();
    static final DateTimeZone TZ = DateTimeZone.forID("Europe/Moscow");

    public static FlightEventMeta createFlightEventMeta() {
        return new FlightEventMeta(
                "mid31829", FLIGHT_NUM, Option.empty(),
                Option.of(PLANNED_TS.toDateTime(TZ).toLocalDateTime()),
                new FlightCity("depCity", Option.of(GEO_ID)), Option.of(new FlightItem("depAirport")),
                PLANNED_TS.toDateTime(TZ).plus(Duration.standardHours(3)).toLocalDateTime(), TZ,
                new FlightCity("Хошимин"), Option.empty(),
                Option.empty(), Option.empty(),
                Option.of(FlightSource.RASP),
                Option.empty(), Option.empty(), Option.empty(),
                Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty());
    }

    public static JsonObject createEventJsonData() {
        return new JsonObject(Tuple2List.fromPairs(
                "@context", JsonString.valueOf("http://schema.org"),
                "@type", JsonString.valueOf("Event")));
    }
}