package ru.yandex.reminders.logic.event;

import java.util.NoSuchElementException;
import java.util.Optional;

import lombok.val;
import org.apache.commons.codec.binary.Base64;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.commune.mail.BodyPart;
import ru.yandex.commune.mail.ContentType;
import ru.yandex.commune.mail.MailMessage;
import ru.yandex.commune.mail.MailMessageHeader;
import ru.yandex.commune.mail.Multipart;
import ru.yandex.reminders.logic.callmeback.in.CallbackRequest;
import ru.yandex.reminders.logic.sending.MailMessageCreator;
import ru.yandex.reminders.logic.sending.emails.EventEmailInfo;
import ru.yandex.reminders.util.MailUtils;

public class EventReminderMessageCreator {
    // DARIA-31932
    private static MailMessageHeader HOTEL_X_YANDEX_HINT_HEADER =
            new MailMessageHeader("X-Yandex-Hint", Base64.encodeBase64String((
                    "label=SystMetkaSO:greeting\n" +
                            "label=SystMetkaSO:s_travel\n" +
                            "label=SystMetkaSO:hotel").getBytes()));

    public static MailMessage createMail(CallbackRequest request) {
        Multipart body = Multipart.empty();

        val reminder = request.getReminder();

        if (reminder.getBodyHtml().isPresent()) {
            body = body.addPart(BodyPart.create(reminder.getBodyHtml().get(), ContentType.TEXT_HTML_UTF8));
        }
        if (reminder.getBodyText().isPresent()) {
            body = body.addPart(BodyPart.create(reminder.getBodyText().get(), ContentType.TEXT_PLAIN_UTF8));
        }
        MailMessage created = MailMessageCreator.create(plainInfo(request));

        body = body.getParts().isNotEmpty() ? body : (Multipart) created.getContent();

        ListF<MailMessageHeader> headers =
                Option.when(SpecialClientIds.isHotel(request.getCid()), HOTEL_X_YANDEX_HINT_HEADER);

        return new MailMessage(headers, body)
                .withFrom(MailUtils.mailAddressForSenderName(reminder.getFrom().toOptional())) // CAL-6586
                .withSubject(created.getSubject().get());
    }

    public static String createSms(CallbackRequest request) {
        String senderPrefix = request.getSenderName().map(s -> s + " напоминает: ").orElse("");
        val reminder = request.getReminder();

        if (reminder.getText().isPresent()) {
            return senderPrefix + reminder.getText().get();
        } else {
            return senderPrefix + getName(request);
        }
    }

    private static EventEmailInfo plainInfo(CallbackRequest request) {
        return new EventEmailInfo(
                getName(request), request.getData().getDescription(),
                request.getReminder().getSubject(), Option.x(request.getSenderName()),
                request.getData().getData());
    }

    private static String getName(CallbackRequest request) {
        return request.getData().getName().getOrThrow("unnamed event");
    }

}
