package ru.yandex.reminders.logic.event;

import lombok.Data;
import lombok.val;
import org.bson.types.ObjectId;
import org.joda.time.Instant;
import ru.yandex.misc.bender.annotation.BenderTextValue;

@Data
public class IterationKey {
    private final Instant firstSendTs;
    private final ObjectId id;

    public static IterationKey of(Event event) {
        return new IterationKey(event.getReminders().first().getSendTs(), event.getMongoId());
    }

    @BenderTextValue
    public static IterationKey parse(String value) {
        val parts = value.split("-");

        return parts.length > 1
                ? new IterationKey(new Instant(Long.parseLong(parts[0], 16)), new ObjectId(parts[1]))
                : new IterationKey(new Instant(0), new ObjectId(parts[0]));
    }

    @BenderTextValue
    public String serialize() {
        return Long.toString(firstSendTs.getMillis(), 16) + "-" + id.toHexString();
    }
}
