package ru.yandex.reminders.logic.event;

import java.util.Optional;

import com.mongodb.client.model.Filters;
import lombok.val;
import org.bson.conversions.Bson;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo3.FiltersX;
import ru.yandex.commune.mongo3.MongoUtils;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.misc.db.q.SqlOrder;

public enum Order {
    SOONEST_FIRST,
    SOONEST_LAST,
    NEW_FIRST,
    OLD_FIRST,
    UNORDERED,
    ;

    private static Order getOrder(boolean pred, Order a, Order b) {
        if (pred) {
            return a;
        }
        return b;
    }

    public static Order of(Optional<Boolean> soonestFirst, Optional<Boolean> newFirst) {
        return soonestFirst
                .map(b -> getOrder(b, Order.SOONEST_FIRST, Order.SOONEST_LAST))
                .orElse(
                        newFirst
                                .map(b -> getOrder(b, Order.NEW_FIRST, Order.OLD_FIRST))
                                .orElse(Order.UNORDERED)
                );
    }

    public SqlOrder toSqlOrderFor(SqlLimits limits) {
        return this == SOONEST_FIRST ? SqlOrder.orderByColumn("reminders.0.sendTs").andThen(FiltersX.ID_FIELD)
                : this == SOONEST_LAST ? SqlOrder.orderByColumnDesc("reminders.0.sendTs").andThenDesc(FiltersX.ID_FIELD)
                : this == NEW_FIRST ? SqlOrder.orderByColumnDesc(FiltersX.ID_FIELD)
                : this == OLD_FIRST ? SqlOrder.orderByColumn(FiltersX.ID_FIELD)
                : limits.isAll() ? SqlOrder.unordered() : OLD_FIRST.toSqlOrderFor(limits);
    }

    public Bson toFilter(IterationKey iterationId) {
        val sendTs = MongoUtils.toMongoValue(iterationId.getFirstSendTs());
        val prevId = iterationId.getId();

        if (this == SOONEST_FIRST) {
            return Filters.or(Filters.gt("reminders.0.sendTs", sendTs),
                    Filters.and(Filters.eq("reminders.0.sendTs", sendTs), Filters.gt(FiltersX.ID_FIELD, prevId)));
        }
        if (this == SOONEST_LAST) {
            return Filters.or(Filters.lt("reminders.0.sendTs", sendTs),
                    Filters.and(Filters.eq("reminders.0.sendTs", sendTs), Filters.lt(FiltersX.ID_FIELD, prevId)));
        }
        return this == NEW_FIRST
                ? Filters.lt(FiltersX.ID_FIELD, prevId)
                : Filters.gt(FiltersX.ID_FIELD, prevId);
    }
}
