package ru.yandex.reminders.logic.event;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.reminders.api.reminder.Source;

public class SpecialClientIds {
    public static final String TV = "yandex-tv";
    public static final String FLIGHT = "yandex-flight";
    public static final String HOTEL = "yandex-hotel";
    public static final String WMI = "yandex-wmi";
    public static final String NEZABUDKA = "yandex-nezabudka";
    public static final String CALLMEBACK = "yandex-callmeback";
    public static final String CALENDAR = "yandex-calendar";

    private static final SetF<String> ALL_IDS = ClassX.wrap(SpecialClientIds.class)
            .getAllDeclaredFields()
            .filter(f -> f.isStatic() && f.isPublic() && f.getType().is(String.class))
            .map(f -> f.get(SpecialClientIds.class).toString())
            .unique();

    public static boolean isSpecial(String clientId) {
        return ALL_IDS.containsTs(clientId);
    }

    public static boolean isNezabudka(String clientId) {
        return NEZABUDKA.equals(clientId);
    }

    public static boolean isWmi(String clientId) {
        return WMI.equals(clientId);
    }

    public static boolean isFlight(String clientId) {
        return FLIGHT.equals(clientId);
    }

    public static boolean isTv(String clientId) {
        return TV.equals(clientId);
    }

    public static boolean isHotel(String clientId) {
        return HOTEL.equals(clientId);
    }

    public static boolean isCalendar(String clientId) {
        return CALENDAR.equals(clientId);
    }

    public static Source hackSource(String clientId) {
        return clientId.startsWith("yandex-") ? Source.INTERNAL : Source.EXTERNAL;
    }

}
